﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.IO;
using System.Reflection;
using System.Collections.Generic;
using System.ComponentModel;
using System.Threading;
using System.Threading.Tasks;
using UPImage;
using UPImage.FileFormat;
using UPImage.Data;
using Neurons;
using System.Drawing.Imaging;
using ArchiveSerialization;
namespace NNControl.UPViewer
{
    public enum KpZoom
    {
        ZoomIn,
        ZoomOut
    }
    public partial class UpImageViewer : Neurons.BaseControl
    {
        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern short GetKeyState(int key);

        private DrawEngine drawEngine;
        private DrawObject drawing;
        private Bitmap preview;
        private String folderPath;
        private bool isScrolling = false;
        private bool scrollbars = false;
        private bool selectMode = false;
        private bool shiftSelecting = false;
        private Point ptSelectionStart = new Point();
        private Point ptSelectionEnd = new Point();

        private bool panelDragging = false;
        private bool showPreview = true;
        private Cursor grabCursor = null;
        private Cursor dragCursor = null;
        private UPUnipen currentUnipen;
        private UPImage.Data.UPDataProvider dataProvider;
        private CancellationTokenSource tokenSource;
        private CancellationToken token;
        bool isCancel;
        List<ConvolutionNetwork> networks;
        public List<ConvolutionNetwork> Networks
        {
            get
            {
                return networks;
            }
            set
            {
                if (networks == value)
                    return;
                networks = value;
            }
        }
        public delegate void ImageViewerRotationEventHandler(object sender, ImageViewerRotationEventArgs e);
        public event ImageViewerRotationEventHandler AfterRotation;
        protected override void AddObject(int iCondition, object value)
        {
           
            switch (iCondition)
            {
                case 94:
                    //load data fail
                    toolStripStatusLabel.Text = (String)value;
                    if (stopwatch.IsRunning)
                    {
                        // Stop the timer; show the start and reset buttons.
                        stopwatch.Stop();
                    }
                    break;
                case 95:

                    toolStripStatusLabel.Text = (String)value;
                    break;
                case 96:
                    //load data fail
                    toolStripStatusLabel.Text = (String)value;
                    toolStripProgressBar1.Value = 0;
                    btFolderExplorer.Image = global::NNControl.Properties.Resources.folders_explorer;
                    btnOpen.Enabled = true;
                    toolStripProgressBar1.Visible = false;
                    if (stopwatch.IsRunning)
                    {
                        // Stop the timer; show the start and reset buttons.
                        stopwatch.Stop();
                    }
                    break;
                case 97:
                    //load data cussess
                    FillTreeView(dataProvider.Folder);
                    toolStripStatusLabel.Text = (String)value;
                    toolStripProgressBar1.Value = 0;
                    btFolderExplorer.Image = global::NNControl.Properties.Resources.folders_explorer;
                    btnOpen.Enabled = true;
                    toolStripProgressBar1.Visible = false;
                    if (stopwatch.IsRunning)
                    {
                        // Stop the timer; show the start and reset buttons.
                        stopwatch.Stop();
                    }
                    break;
                case 98:
                    //updata progress bar
                    toolStripProgressBar1.Value = (int)value;
                    break;
                case 99:
                    //loadding data
                    btFolderExplorer.Image = global::NNControl.Properties.Resources.Stop_sign;
                    btnOpen.Enabled = false;
                    toolStripStatusLabel.Text = (String)value;
                    toolStripProgressBar1.Visible = true;
                    break;
            }
        }
        protected virtual void OnRotation(ImageViewerRotationEventArgs e)
        {
            if (AfterRotation != null)
            {
                AfterRotation(this, e);
            }
        }

        public int PanelWidth
        {
            get
            {
                if (pbFull != null)
                {
                    return pbFull.Width;
                }
                else
                {
                    return 0;
                }
            }
        }

        public int PanelHeight
        {
            get
            {
                if (pbFull != null)
                {
                    return pbFull.Height;
                }
                else
                {
                    return 0;
                }
            }
        }
        public int PreviewPanelWidth
        {
            get
            {
                return pbPanel.Width;
            }
        }
        public int PreviewPanelHeight
        {
            get
            {
                return pbPanel.Height;
            }
        }
        public delegate void ImageViewerZoomEventHandler(object sender, ImageViewerZoomEventArgs e);
        public event ImageViewerZoomEventHandler AfterZoom;

        protected virtual void OnZoom(ImageViewerZoomEventArgs e)
        {
            if (AfterZoom != null)
            {
                AfterZoom(this, e);
            }
        }

        public void InvalidatePanel()
        {
            this.pbFull.Invalidate();
        }

        public bool Scrollbars
        {
            get { return scrollbars; }
            set
            {
                scrollbars = value;
                DisplayScrollbars();
                SetScrollbarValues();
            }
        }

        private bool IsKeyPressed(int key)
        {
            bool keyPressed = false;
            short result = GetKeyState(key);

            switch (result)
            {
                case 0:
                    // Not pressed and not toggled
                    keyPressed = false;
                    break;

                case 1:
                    // Not presses but toggled
                    keyPressed = false;
                    break;

                default:
                    // Pressed
                    keyPressed = true;
                    break;
            }

            return keyPressed;
        }

        public bool OpenButton
        {
            get { return btnOpen.Visible; }
            set
            {
                if (value)
                {
                    btnOpen.Show();
                    // Making sure it's aligned properly

                    btnPreview.Location = new Point(btnOpen.Location.X + btnOpen.Width + 2, btnPreview.Location.Y);
                    panelNavigation.Location = new Point(btnPreview.Location.X + btnPreview.Width + 2, btnPreview.Location.Y);
                }
                else
                {
                    btnOpen.Hide();
                   
                    // Making sure it's aligned properly
                    btnPreview.Location = new Point(btnOpen.Location.X, btnPreview.Location.Y);
                    panelNavigation.Location = new Point(btnPreview.Location.X + btnPreview.Width + 2, btnPreview.Location.Y);
                  
                }
            }
        }

        public bool PreviewButton
        {
            get { return btnPreview.Visible; }
            set
            {
                if (value)
                {
                    btnPreview.Show();
                    panelNavigation.Location = new Point(btnPreview.Location.X + btnPreview.Width+2, btnPreview.Location.Y);
                }
                else
                {
                    btnPreview.Hide();
                    btnPreview.Visible = false;
                    panelNavigation.Location = new Point(btnPreview.Location.X + 2, btnOpen.Location.Y);               
                }
            }
        }

        public override bool AllowDrop
        {
            get
            {
                return base.AllowDrop;
            }
            set
            {
                this.pbFull.AllowDrop = value;
                base.AllowDrop = value;
            }
        }

        public double Zoom
        {
            get { return Math.Round(drawing.Zoom * 100, 0); }
            set
            {
                if (value > 0)
                {
                    // Make it a double!
                    double zoomDouble = (double)value / (double)100;

                    drawing.SetZoom(zoomDouble);
                    UpdatePanels(true);

                    btnZoomIn.Focus();
                }
            }
        }

        public Size OriginalSize
        {
            get { return drawing.OriginalSize; }
        }

        public Size CurrentSize
        {
            get { return drawing.CurrentSize; }
        }

        public Color MenuColor
        {
            get { return panelMenu.BackColor; }
            set
            {
                panelMenu.BackColor = value;
                panelPreview.BackColor = value;
                panelNavigation.BackColor = value;
            }
        }

        public Color MenuPanelColor
        {
            get { return panelMenu.BackColor; }
            set
            {
                panelMenu.BackColor = value;
            }
        }

        public Color NavigationPanelColor
        {
            get { return panelNavigation.BackColor; }
            set
            {
                panelNavigation.BackColor = value;
            }
        }

        public Color PreviewPanelColor
        {
            get { return panelPreview.BackColor; }
            set
            {
                panelPreview.BackColor = value;
            }
        }

        public Color NavigationTextColor
        {
            get { return lblNavigation.ForeColor; }
            set { lblNavigation.ForeColor = value; }
        }

        public Color TextColor
        {
            get { return lblPreview.ForeColor; }
            set
            {
                lblPreview.ForeColor = value;
                lblNavigation.ForeColor = value;
            }
        }

        public Color PreviewTextColor
        {
            get { return lblPreview.ForeColor; }
            set { lblPreview.ForeColor = value; }
        }

        public Color BackgroundColor
        {
            get { return pbFull.BackColor; }
            set { pbFull.BackColor = value; }
        }

        public string PreviewText
        {
            get { return lblPreview.Text; }
            set { lblPreview.Text = value; }
        }

        public string ImagePath
        {
            set 
            { 
                drawing.ImagePath = value;

                UpdatePanels(true);
                // scrollbars
                DisplayScrollbars();
                SetScrollbarValues();
            }
        }

        public Bitmap Image
        {
            get
            {
                return drawing.Image;
            }
            set
            {
                drawing.Image = value;
                if (value != null)
                {
                    UpdatePanels(true);
                }
                // scrollbars
                DisplayScrollbars();
                SetScrollbarValues();
            }
        }

        public int Rotation
        {
            get { return drawing.Rotation; }
            set
            {
                // Making sure the rotation is 0, 90, 180 or 270 degrees!
                if (value == 90 || value == 180 || value == 270 || value == 0)
                {
                     drawing.Rotation = value;
                }
            }
        }

        private void Preview()
        {
            // Hide preview panel mechanics
            // Making sure that UpdatePanels doesn't get called when it's hidden!

            if (showPreview != pbPanel.Visible)
            {
                if (showPreview == false)
                {
                    //panelPreview.Hide();
                    //pbPanel.Hide();
                    splitContainerMain.Panel2Collapsed = true;
                    panelMenu.Width = pbFull.Width;
                    InitControl();
                    drawing.AvoidOutOfScreen();
                    pbFull.Refresh();
                }
                else
                {
                    //panelPreview.Show();
                    //pbPanel.Show();
                    splitContainerMain.Panel2Collapsed=false;
                    panelMenu.Width = pbFull.Width;
                      
                    InitControl();
                    drawing.AvoidOutOfScreen();
                    pbFull.Refresh();

                    UpdatePanels(true);
                }
            }
        }

        public bool ShowPreview
        {
            get { return showPreview; }
            set
            {
                if (showPreview != value)
                {
                    showPreview = value;
                    Preview();
                }
            }
        }

        public UpImageViewer()
        {
            // DrawEngine & DrawObject initiralization
            drawEngine = new DrawEngine();
            drawing = new DrawObject(this);
            currentUnipen = new UPUnipen();
            dataProvider = null;
            isCancel = false;
            tokenSource = null;
            folderPath = "";
            // Stream to initialize the cursors.
            Stream imgStream = null;
            networks = null;
            try
            {
                Assembly a = Assembly.GetExecutingAssembly();

                imgStream = a.GetManifestResourceStream("NNControl.Resources.Grab.cur");
                if (imgStream != null)
                {
                    grabCursor = new Cursor(imgStream);
                    imgStream = null;
                }

                imgStream = a.GetManifestResourceStream("NNControl.Resources.Drag.cur");
                if (imgStream != null)
                {
                    dragCursor = new Cursor(imgStream);
                    imgStream = null;
                }
            }
            catch
            {
                // Cursors could not be found
            }

            InitializeComponent();

            InitControl();

            Preview();
        }

        private void DisposeControl()
        {
            // No memory leaks here
            if (drawing != null)
            {
                drawing.Dispose();
            }

            if (drawEngine != null)
            {
                drawEngine.Dispose();
            }

            if (preview != null)
            {
                preview.Dispose();
            }
        }

        public void InitControl()
        {
            // Make sure panel is DoubleBuffering
            drawEngine.CreateDoubleBuffer(pbFull.CreateGraphics(), pbFull.Size.Width, pbFull.Size.Height);
            udPenwidth.Value = 10;
            rbLine.Checked = true;
            cbMultipenColor.Checked = true;
            if (!scrollbars)
            {
                sbHoriz.Visible = false;
                sbVert.Visible = false;
                sbPanel.Visible = false;
            }
        }

        private void FocusOnMe()
        {
            // Do not lose focus! ("Fix" for the Scrolling issue)
            this.Focus();
        }

        private void DisplayScrollbars()
        {
            if (scrollbars)
            {
                if (this.Image != null)
                {
                    int perPercent = this.CurrentSize.Width / 100;

                    if (this.CurrentSize.Width - perPercent > this.pbFull.Width)
                    {
                        this.sbHoriz.Visible = true;
                    }
                    else
                    {
                        this.sbHoriz.Visible = false;
                    }

                    if (this.CurrentSize.Height - perPercent > this.pbFull.Height)
                    {
                        this.sbVert.Visible = true;
                    }
                    else
                    {
                        this.sbVert.Visible = false;
                    }

                    if (this.sbVert.Visible == true && this.sbHoriz.Visible == true)
                    {
                        this.sbPanel.Visible = true;
                        this.sbVert.Height = this.pbFull.Height - 18;
                        this.sbHoriz.Width = this.pbFull.Width - 18;
                    }
                    else
                    {
                        this.sbPanel.Visible = false;

                        if (this.sbVert.Visible)
                        {
                            this.sbVert.Height = this.pbFull.Height;
                        }
                        else
                        {
                            this.sbHoriz.Width = this.pbFull.Width;
                        }
                    }
                }
                else
                {
                    this.sbHoriz.Visible = false;
                    this.sbVert.Visible = false;
                    this.sbPanel.Visible = false;
                }
            }
            else
            {
                this.sbHoriz.Visible = false;
                this.sbVert.Visible = false;
                this.sbPanel.Visible = false;
            }
        }

        private void SetScrollbarValues()
        {
            if (scrollbars)
            {
                if (sbHoriz.Visible)
                {
                    isScrolling = true;
                    double perPercent = (double)this.CurrentSize.Width / 101.0;
                    double totalPercent = (double)this.pbFull.Width / perPercent;

                    sbHoriz.Minimum = 0;
                    sbHoriz.Maximum = 100;
                    sbHoriz.LargeChange = Convert.ToInt32(Math.Round(totalPercent, 0));

                    double value = (double)((-this.drawing.BoundingBox.X) / perPercent);

                    if (value > sbHoriz.Maximum) { sbHoriz.Value = (sbHoriz.Maximum - sbHoriz.LargeChange) + ((sbHoriz.LargeChange > 0) ? 1 : 0); }
                    else if (value < 0) { sbHoriz.Value = 0; }
                    else
                    {
                        sbHoriz.Value = Convert.ToInt32(Math.Round(value, 0));
                    }
                    isScrolling = false;
                }

                if (sbVert.Visible)
                {
                    isScrolling = true;
                    double perPercent = (double)this.CurrentSize.Height / 101.0;
                    double totalPercent = (double)this.pbFull.Height / perPercent;

                    sbVert.Minimum = 0;
                    sbVert.Maximum = 100;
                    sbVert.LargeChange = Convert.ToInt32(Math.Round(totalPercent, 0));

                    double value = (double)((-this.drawing.BoundingBox.Y) / perPercent);

                    if (value > sbVert.Maximum) { sbVert.Value = (sbVert.Maximum - sbVert.LargeChange) + ((sbVert.LargeChange > 0) ? 1 : 0); }
                    else if (value < 0) { sbVert.Value = 0; }
                    else
                    {
                        sbVert.Value = Convert.ToInt32(Math.Round(value, 0));
                    }
                    isScrolling = false;
                }
            }
            else
            {
                sbHoriz.Visible = false;
                sbVert.Visible = false;
            }
        }

        private void ImageViewerLoad(object sender, EventArgs e)
        {
            // Loop for ComboBox Items! Increments by 25%
            for (double z = 0.25; z <= 4.0; z = z + 0.25)
            {
                cbZoom.Items.Add(z * 100 + "%");
            }

            cbZoom.SelectedIndex = 3;
        }

        private void ImageViewerResize(object sender, EventArgs e)
        {
            InitControl();
            drawing.AvoidOutOfScreen();
            UpdatePanels(true);
        }

        private void pbFull_Paint(object sender, PaintEventArgs e)
        {
            // Can I double buffer?
            if (drawEngine.CanDoubleBuffer())
            {
                // Yes I can!
                drawEngine.g.FillRectangle(new SolidBrush(pbFull.BackColor), e.ClipRectangle.X, e.ClipRectangle.Y, e.ClipRectangle.Width, e.ClipRectangle.Height);

                // Drawing to backBuffer
                drawing.Draw(drawEngine.g);

                // Drawing to Panel
                drawEngine.Render(e.Graphics);
                
            }
        }

        private void pbFull_MouseDown(object sender, MouseEventArgs e)
        {
            pbFull.Focus();
            if (e.Button == MouseButtons.Left)
            {
                // Left Shift or Right Shift pressed? Or is select mode one?
                if (this.IsKeyPressed(0xA0) || this.IsKeyPressed(0xA1) || selectMode == true)
                {
                    // Fancy cursor
                    pbFull.Cursor = Cursors.Cross;

                    shiftSelecting = true;

                    // Initial seleciton
                    ptSelectionStart.X = e.X;
                    ptSelectionStart.Y = e.Y;

                    // No selection end
                    ptSelectionEnd.X = -1;
                    ptSelectionEnd.Y = -1;
                }
                else
                {
                    // Start dragging
                    drawing.BeginDrag(new Point(e.X, e.Y));

                    // Fancy cursor
                    if (grabCursor != null)
                    {
                        pbFull.Cursor = grabCursor;
                    }
                }
            }
        }

        private void pbFull_MouseUp(object sender, MouseEventArgs e)
        {
            // Am i dragging or selecting?
            if (shiftSelecting == true)
            {
                // Calculate my selection rectangle
                Rectangle rect = CalculateReversibleRectangle(ptSelectionStart, ptSelectionEnd);

                // Clear the selection rectangle
                ptSelectionEnd.X = -1;
                ptSelectionEnd.Y = -1;
                ptSelectionStart.X = -1;
                ptSelectionStart.Y = -1;

                // Stop selecting
                shiftSelecting = false;

                // Position of the panel to the screen
                Point ptPbFull = PointToScreen(pbFull.Location);

                // Zoom to my selection
                drawing.ZoomToSelection(rect, ptPbFull);

                // Refresh my screen & update my preview panel
                pbFull.Refresh();
                UpdatePanels(true);
            }
            else
            {
                // Stop dragging and update my panels
                drawing.EndDrag();
                UpdatePanels(true);

                // Fancy cursor
                if (dragCursor != null)
                {
                    pbFull.Cursor = dragCursor;
                }
            }
        }

        private void pbFull_MouseMove(object sender, MouseEventArgs e)
        {
            // Am I dragging or selecting?
            if (shiftSelecting == true)
            {
                // Keep selecting
                ptSelectionEnd.X = e.X;
                ptSelectionEnd.Y = e.Y;
                
                Rectangle pbFullRect = new Rectangle(0, 0, pbFull.Width - 1, pbFull.Height - 1);

                // Am I still selecting within my panel?
                if (pbFullRect.Contains(new Point(e.X, e.Y)))
                {
                    // If so, draw my Rubber Band Rectangle!
                    Rectangle rect = CalculateReversibleRectangle(ptSelectionStart, ptSelectionEnd);
                    DrawReversibleRectangle(rect);
                }
            }
            else
            {
                // Keep dragging
              
                
                drawing.Drag(new Point(e.X, e.Y));
                if (drawing.IsDragging)
                {
                    UpdatePanels(false);
                }
                else
                {
                    // I'm not dragging OR selecting
                    // Make sure if left or right shift is pressed to change cursor

                    if (this.IsKeyPressed(0xA0) || this.IsKeyPressed(0xA1) || selectMode == true) 
                    {
                        // Fancy Cursor
                        if (pbFull.Cursor != Cursors.Cross)
                        {
                            pbFull.Cursor = Cursors.Cross;
                        }
                    }
                    else
                    {
                        // Fancy Cursor
                        if (pbFull.Cursor != dragCursor)
                        {
                            pbFull.Cursor = dragCursor;
                        }
                    }
                }
            }
        }

        private void ImageViewer_MouseWheel(object sender, MouseEventArgs e)
        {
            drawing.Scroll(sender, e);

            if (drawing.Image != null)
            {
                if (e.Delta < 0)
                {
                    OnZoom(new ImageViewerZoomEventArgs(drawing.Zoom, KpZoom.ZoomOut));
                }
                else
                {
                    OnZoom(new ImageViewerZoomEventArgs(drawing.Zoom, KpZoom.ZoomIn));
                }
            }

            UpdatePanels(true);
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.InitialDirectory = Environment.CurrentDirectory;
            openFileDialog.Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*";
            openFileDialog.FilterIndex = 2;
            openFileDialog.RestoreDirectory = true;
           
            if (openFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                try
                {
                    UPDataSet upDataset = new UPDataSet();
                    //set upDataset.InitialDirectory=full path of unipen folder if it is not "UnipenData".
                    upDataset.InitialDirectory = "";
                    upDataset.FillDataSetFromFile(openFileDialog.FileName);
                    if (upDataset.Datalayouts.Count > 0)
                    {
                        // Suppress repainting the TreeView until all the objects have been created.
                        tvMain.Nodes.Clear();
                        tvMain.BeginUpdate();
                        // Clear the TreeView each time the method is called.
                        // Add a root TreeNode for each Customer object in the ArrayList.

                        int id = 0;
                        foreach (var dl in upDataset.Datalayouts)
                        {
                            String st = String.Format("{0} {1}", "Data layout:", Convert.ToString(id));
                            TreeNode tn = new TreeNode(st);
                            tvMain.Nodes.Add(tn);

                            if (dl.UpUnipens.Count > 0)
                            {
                                foreach (var up in dl.UpUnipens)
                                {
                                    st = String.Format("{0} {1}", "Label:", up.Label);
                                    TreeNode childnode = new TreeNode(st);
                                    childnode.Name = "Label";
                                    childnode.ImageIndex = 4;
                                    childnode.Tag = up;
                                    tvMain.Nodes[id].Nodes.Add(childnode);
                                }

                            }
                            id++;
                        }
                        // Begin repainting the TreeView.
                        tvMain.EndUpdate();
                        if (tvMain.Nodes.Count > 0)
                        {
                            foreach (TreeNode nd in tvMain.Nodes)
                            {
                                //expand the firt node having children nodes
                                if (nd.Nodes.Count > 0)
                                {
                                    nd.ExpandAll();
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (Exception ex)
                { 
                
                }
            }
        }
    
        private void btnRotate270_Click(object sender, EventArgs e)
        {
            if (drawing != null)
            {
                drawing.Rotate270();

                // AfterRotation Event
                OnRotation(new ImageViewerRotationEventArgs(drawing.Rotation));
                UpdatePanels(true);
            }
        }

        private void btnRotate90_Click(object sender, EventArgs e)
        {
            if (drawing != null)
            {
                drawing.Rotate90();

                // AfterRotation Event
                OnRotation(new ImageViewerRotationEventArgs(drawing.Rotation));
                UpdatePanels(true);
            }
        }

        public void Rotate90()
        {
            if (drawing != null)
            {
                drawing.Rotate90();

                // AfterRotation Event
                OnRotation(new ImageViewerRotationEventArgs(drawing.Rotation));
                UpdatePanels(true);
            }
        }

        public void Rotate180()
        {
            if (drawing != null)
            {
                drawing.Rotate180();

                // AfterRotation Event
                OnRotation(new ImageViewerRotationEventArgs(drawing.Rotation));
                UpdatePanels(true);
            }
        }

        public void Rotate270()
        {
            if (drawing != null)
            {
                drawing.Rotate270();

                // AfterRotation Event
                OnRotation(new ImageViewerRotationEventArgs(drawing.Rotation));
                UpdatePanels(true);
            }
        }

        private void btnZoomOut_Click(object sender, EventArgs e)
        {
            drawing.ZoomOut();

            // AfterZoom Event
            if (drawing.Image != null)
            {
                OnZoom(new ImageViewerZoomEventArgs(drawing.Zoom, KpZoom.ZoomOut));
            }
            UpdatePanels(true);
        }

        private void btnZoomIn_Click(object sender, EventArgs e)
        {
            drawing.ZoomIn();

            // AfterZoom Event
            if (drawing.Image != null)
            {
                OnZoom(new ImageViewerZoomEventArgs(drawing.Zoom, KpZoom.ZoomIn));
            }
            UpdatePanels(true);
        }

        private void btnFitToScreen_Click(object sender, EventArgs e)
        {
            drawing.FitToScreen();
            UpdatePanels(true);
        }

        private void cbZoom_SelectedIndexChanged(object sender, EventArgs e)
        {
            double zoom = (cbZoom.SelectedIndex + 1) * 0.25;
            double originalZoom = drawing.Zoom;

            if (drawing.Zoom != zoom)
            {
                drawing.SetZoom(zoom);

                if (drawing.Image != null)
                {
                    if (zoom > originalZoom)
                    {
                        OnZoom(new ImageViewerZoomEventArgs(drawing.Zoom, KpZoom.ZoomIn));
                    }
                    else
                    {
                        OnZoom(new ImageViewerZoomEventArgs(drawing.Zoom, KpZoom.ZoomOut));
                    }
                }

                UpdatePanels(true);
            }
        }

        private void UpdatePanels(bool updatePreview)
        {
            if (drawing.CurrentSize.Width > 0 && drawing.OriginalSize.Width > 0)
            {
                // scrollbars
                DisplayScrollbars();
                SetScrollbarValues();

                // Make sure panel is up to date
                pbFull.Refresh();

                // Calculate zoom
                double zoom = Math.Round(((double)drawing.CurrentSize.Width / (double)drawing.OriginalSize.Width), 2);

                // Display zoom in percentages
                cbZoom.Text = (int)(zoom * 100) + "%";

                if (updatePreview && drawing.PreviewImage != null && pbPanel.Visible == true)
                {
                    // No memory leaks here
                    if (preview != null)
                    {
                        preview.Dispose();
                        preview = null;
                    }

                    // New preview
                    preview = new Bitmap(drawing.PreviewImage.Size.Width, drawing.PreviewImage.Size.Height);
                    // New Graphics from the new bitmap we created (Empty)
                    using (Graphics g = Graphics.FromImage(preview))
                    {
                        // Draw the image on the bitmap
                        g.DrawImage(drawing.PreviewImage, 0, 0, drawing.PreviewImage.Size.Width, drawing.PreviewImage.Size.Height);

                        double ratioX = (double)drawing.PreviewImage.Size.Width / (double)drawing.CurrentSize.Width;
                        double ratioY = (double)drawing.PreviewImage.Size.Height / (double)drawing.CurrentSize.Height;

                        double boxWidth = pbFull.Width * ratioX;
                        double boxHeight = pbFull.Height * ratioY;
                       
                        double positionX;
                        double positionY;
                        //transform to center of picture box
                        if (drawing.BoundingBox.Width <= pbFull.Width)
                        {
                            positionX = 0;
                            boxWidth = drawing.PreviewImage.Width - 2;
                        }
                        else
                        { 
                            positionX = ((drawing.BoundingBox.X - (drawing.BoundingBox.X * 2)) * ratioX)-1;
                        }
                        if (drawing.BoundingBox.Height <= pbFull.Height)
                        {
                            positionY = 0;
                            boxHeight = drawing.PreviewImage.Height - 2;

                        }
                        else
                        {
                            positionY = ((drawing.BoundingBox.Y - (drawing.BoundingBox.Y * 2)) * ratioY) - 1;
                        }
                        // Making the red pen
                        Pen pen = new Pen(Color.Red, 1);

                        if (boxHeight >= drawing.PreviewImage.Size.Height)
                        {
                            boxHeight = drawing.PreviewImage.Size.Height - 1;
                        }
                        else if ((boxHeight + positionY) > drawing.PreviewImage.Size.Height)
                        {
                            boxHeight = drawing.PreviewImage.Size.Height - (positionY);
                        }

                        if (boxWidth >= drawing.PreviewImage.Size.Width)
                        {
                            boxWidth = drawing.PreviewImage.Size.Width - 1;
                        }
                        else if ((boxWidth + positionX) > drawing.PreviewImage.Size.Width)
                        {
                            boxWidth = drawing.PreviewImage.Size.Width - (positionX);
                        }

                        // Draw the rectangle on the bitmap
                       
                        g.DrawRectangle(pen, new Rectangle((int)positionX, (int)positionY, (int)boxWidth, (int)boxHeight));
                    }

                    // Display the bitmap
                    pbPanel.Image = preview;
                    pbPanel.Refresh();
                }
            }
        }

        private void pbPanel_MouseDown(object sender, MouseEventArgs e)
        {
            if (drawing.PreviewImage != null)
            {
                if (panelDragging == false)
                {
                    int x = e.X;
                    int y = e.Y;
                    int w = drawing.PreviewImage.Width;
                    int h = drawing.PreviewImage.Height;
                    if (drawing.PreviewImage.Width < pbPanel.Width)
                    {
                        x = e.X - (pbPanel.Width - drawing.PreviewImage.Width) / 2;
                        if (x < 0)
                        {
                            x = 0;
                        }
                    }
                    if (drawing.PreviewImage.Height < pbPanel.Height)
                    {
                        y = e.Y - (pbPanel.Height - drawing.PreviewImage.Height) / 2;
                        if (y < 0)
                        {
                            y = 0;
                        }
                    }
                    drawing.JumpToOrigin(x, y, w, h, pbFull.Width, pbFull.Height);

                    UpdatePanels(true);
                    panelDragging = true;
                }
            }
        }

        private void pbFull_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            drawing.JumpToOrigin(e.X + (drawing.BoundingBox.X - (drawing.BoundingBox.X * 2)), e.Y + (drawing.BoundingBox.Y - (drawing.BoundingBox.Y * 2)), pbFull.Width, pbFull.Height);
            UpdatePanels(true);
        }

        private void pbFull_MouseHover(object sender, EventArgs e)
        {
            // Left shift or Right shift!
            if (this.IsKeyPressed(0xA0) || this.IsKeyPressed(0xA1))
            {
                // Fancy cursor
                pbFull.Cursor = Cursors.Cross;
            }
            else
            {
                // Fancy cursor if not dragging
                if (!drawing.IsDragging)
                {
                    pbFull.Cursor = dragCursor;
                }
            }
        }

        private void ImageViewer_Click(object sender, EventArgs e)
        {
            FocusOnMe();
        }

        private void pbFull_Click(object sender, EventArgs e)
        {
            FocusOnMe();
        }

        private void pbPanel_MouseMove(object sender, MouseEventArgs e)
        {
            if (panelDragging)
            {
                int x = e.X;
                int y = e.Y;
                int w = drawing.PreviewImage.Width;
                int h = drawing.PreviewImage.Height;
                if (drawing.PreviewImage.Width < pbPanel.Width)
                {
                    x = e.X - (pbPanel.Width - drawing.PreviewImage.Width) / 2;
                    if (x < 0)
                    {
                        x = 0;
                    }
                }
                if (drawing.PreviewImage.Height < pbPanel.Height)
                {
                    y = e.Y - (pbPanel.Height - drawing.PreviewImage.Height) / 2;
                    if (y < 0)
                    {
                        y = 0;
                    }
                }
                drawing.JumpToOrigin(x, y, w, h, pbFull.Width, pbFull.Height);
                UpdatePanels(true);
            }
        }

        private void pbPanel_MouseUp(object sender, MouseEventArgs e)
        {
            panelDragging = false;
        }

        private void pbFull_MouseEnter(object sender, EventArgs e)
        {
            if (this.IsKeyPressed(0xA0) || this.IsKeyPressed(0xA1) || selectMode == true)
            {
                pbFull.Cursor = Cursors.Cross;
            }
            else
            {
                if (dragCursor != null)
                {
                    pbFull.Cursor = dragCursor;
                }
            }
        }

        private void pbFull_MouseLeave(object sender, EventArgs e)
        {
            pbFull.Cursor = Cursors.Default;
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            if (this.ShowPreview)
            {
                this.ShowPreview = false;
            }
            else
            {
                this.ShowPreview = true;
            }
        }

        private void cbZoom_KeyPress(object sender, KeyPressEventArgs e)
        {
            try
            {
                // If it's not a digit, delete or backspace then make sure the input is being handled with. (Suppressed)
                if (!Char.IsDigit(e.KeyChar) && e.KeyChar != (char)Keys.Delete && e.KeyChar != (char)Keys.Back)
                {
                    // If enter is pressed apply the entered zoom
                    if (e.KeyChar == (char)Keys.Return)
                    {
                        int zoom = 0;

                        // Make sure the percent sign is out of the cbZoom.Text
                        int.TryParse(cbZoom.Text.Replace("%", ""), out zoom);

                        // If zoom is higher than zero
                        if (zoom > 0)
                        {
                            // Make it a double!
                            double zoomDouble = (double)zoom / (double)100;

                            drawing.SetZoom(zoomDouble);
                            UpdatePanels(true);

                            btnZoomIn.Focus();
                        }
                    }

                    e.Handled = true;
                }
            }
            catch (Exception ex)
            {
                System.Windows.Forms.MessageBox.Show("ImageViewer error: " + ex.ToString());
            }
        }

        private Rectangle CalculateReversibleRectangle(Point ptSelectStart, Point ptSelectEnd)
        {
            Rectangle rect = new Rectangle();

            ptSelectStart = pbFull.PointToScreen(ptSelectStart);
            ptSelectEnd = pbFull.PointToScreen(ptSelectEnd);

            if (ptSelectStart.X < ptSelectEnd.X)
            {
                rect.X = ptSelectStart.X;
                rect.Width = ptSelectEnd.X - ptSelectStart.X;
            }
            else
            {
                rect.X = ptSelectEnd.X;
                rect.Width = ptSelectStart.X - ptSelectEnd.X;
            }
            if (ptSelectStart.Y < ptSelectEnd.Y)
            {
                rect.Y = ptSelectStart.Y;
                rect.Height = ptSelectEnd.Y - ptSelectStart.Y;
            }
            else
            {
                rect.Y = ptSelectEnd.Y;
                rect.Height = ptSelectStart.Y - ptSelectEnd.Y;
            }

            return rect;
        }

        private void DrawReversibleRectangle(Rectangle rect)
        {
            pbFull.Refresh();
            ControlPaint.DrawReversibleFrame(rect, Color.LightGray, FrameStyle.Dashed);
        }

     
        private void btnMode_Click(object sender, EventArgs e)
        {
            if (selectMode == false)
            {
                selectMode = true;
                this.btnMode.Image = global::NNControl.Properties.Resources.btnDrag;
            }
            else
            {
                selectMode = false;
                this.btnMode.Image = global::NNControl.Properties.Resources.btnSelect;
            }
        }

        private void btnNext_Click(object sender, EventArgs e)
        {

        }

        private void btnBack_Click(object sender, EventArgs e)
        {
           
        }

        private void tbNavigation_KeyPress(object sender, KeyPressEventArgs e)
        {
            try
            {
               
            }
            catch (Exception ex)
            {
                System.Windows.Forms.MessageBox.Show("ImageViewer error: " + ex.ToString());
            }
        }

        private void sbVert_Scroll(object sender, ScrollEventArgs e)
        {
            if (!isScrolling)
            {
                double perPercent = (double)this.CurrentSize.Height / 101.0;

                double value = e.NewValue * perPercent;

                this.drawing.SetPositionY(Convert.ToInt32(Math.Round(value, 0)));

                this.drawing.AvoidOutOfScreen();

                pbFull.Invalidate();

                UpdatePanels(true);
            }
        }

        private void sbHoriz_Scroll(object sender, ScrollEventArgs e)
        {
            if (!isScrolling)
            {
                double perPercent = (double)this.CurrentSize.Width / 101.0;

                double value = e.NewValue * perPercent;

                this.drawing.SetPositionX(Convert.ToInt32(Math.Round(value, 0)));

                this.drawing.AvoidOutOfScreen();

                pbFull.Invalidate();

                UpdatePanels(true);
            }
        }
        void FillTreeView(UPFolder folder)
        {
            TreeNode rootNode = new TreeNode(folder.SafeName);
            rootNode.ImageIndex = 2;
            rootNode.SelectedImageIndex = 2;
            tvMain.Nodes.Clear();
            tvMain.Nodes.Add(rootNode);
            Getsubnode(folder, rootNode);
            if (folder.Files.Count > 0)
            {
                foreach (var tn in folder.Files)
                {
                    TreeNode newNode = new TreeNode(tn.SafeFileName);
                    newNode.Tag = tn.FullPath;
                    newNode.ImageIndex = 0;
                    newNode.SelectedImageIndex = 0;
                    newNode.Name = "file";
                    rootNode.Nodes.Add(newNode);

                }
            }
        }
        void Getsubnode(UPFolder parent, TreeNode tvParent)
        {
            try
            {
                // now that we have the children of the parent, see if they
                // have any child members that need to be scanned.  Scanning 
                // the first level of sub folders insures that you properly 
                // see the '+' or '-' expanding controls on each node that represents
                // a sub folder with it's own children.
                foreach (UPFolder node in parent.KidFolders)
                {
                    if (node.KidFolders.Count > 0 || node.Files.Count > 0)
                    {
                        TreeNode newNode = new TreeNode(node.SafeName);
                        newNode.ImageIndex = 3;
                        newNode.SelectedImageIndex = 3;
                        tvParent.Nodes.Add(newNode);
                        if (node.Files.Count > 0)
                        {
                            foreach (var f in node.Files)
                            {
                                TreeNode file = new TreeNode(f.SafeFileName);
                                file.Tag = f.FullPath;
                                file.ImageIndex = 0;
                                file.SelectedImageIndex = 0;
                                file.Name = "file";
                                newNode.Nodes.Add(file);

                            }
                        }
                        Getsubnode(node, newNode);
                    }

                }
            }
            catch (Exception doh)
            {
                MessageBox.Show(doh.ToString());
            }
        }
        private void dataSetTreeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (e.Node.Name == "file")
            {
                if (e.Node.Nodes.Count==0)
                {
                    UPImage.FileFormat.UPDataSet upDataSet = new UPDataSet();
                    upDataSet.FillDataSetFromFile((String)e.Node.Tag);
                    if (upDataSet.Datalayouts.Count > 0)
                    {
                        // Suppress repainting the TreeView until all the objects have been created.
                        tvMain.BeginUpdate();
                        // Clear the TreeView each time the method is called.
                       // Add a root TreeNode for each Customer object in the ArrayList.

                        int id = 0;
                        foreach (var dl in upDataSet.Datalayouts)
                        {
                            String st = String.Format("{0} {1}", "Data layout:", Convert.ToString(id));
                            TreeNode tn = new TreeNode(st);
                            e.Node.Nodes.Add(tn);

                            if (dl.UpUnipens.Count > 0)
                            {
                                foreach (var up in dl.UpUnipens)
                                {
                                    st= String.Format("Segment:{0}, Label:{1}",dl.UpUnipens.IndexOf(up),up.Label);;
                                    TreeNode childnode = new TreeNode(st);
                                    childnode.Name = "Label";
                                    childnode.ImageIndex = 4;
                                    childnode.Tag = up;
                                    e.Node.Nodes[id].Nodes.Add(childnode);
                                }

                            }
                            id++;

                        }
                        // Begin repainting the TreeView.
                        tvMain.EndUpdate();
                        if (tvMain.Nodes.Count > 0)
                        {
                            foreach (TreeNode nd in tvMain.Nodes)
                            {
                                //expand the firt node having children nodes
                                if (nd.Nodes.Count > 0)
                                {
                                    nd.ExpandAll();
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            else if (e.Node.Name == "Label")
            {
                currentUnipen = (UPUnipen)e.Node.Tag;
                UpdateBitmap();
                UpdatePanels(true);
                if (cbRecognition.Checked)
                {
                    PatternRecognition();
                }
            }
        } 
        /// <summary>
        /// update bitmap when a prameter changed
        /// </summary>
        private void UpdateBitmap()
        {
            UnipenBitmap ibox = new UnipenBitmap(currentUnipen, (int)udPenwidth.Value);
            if (rbLine.Checked)
            {
                ibox.Drawtype = DrawType.Line;
            }
            else if (rbPie.Checked)
            {
                ibox.Drawtype = DrawType.Pie;
            }
            ibox.Multicolor = cbMultipenColor.Checked;
            ibox.PenWidth =(int) udPenwidth.Value;
            ibox.Uppen = cbUppen.Checked;
            ibox.IsBackgroundColor = true;
            Bitmap bmp = ibox.Image;
            //bmp = ImageProcessing.CreateColorPad(bmp, Color.White, 3, 3);
            //bmp = ImageProcessing.MarkIndexedPattern(bmp, ibox.PenWidth, 255);
            if (bmp != null)
            {
                InputPattern pattern = new InputPattern(bmp, 255, new Rectangle(0, 0, bmp.Width, bmp.Height));
                pattern.GetPatternBoundaries(1, 1, false, 10, 10);
                this.Image = pattern.DrawChildPatternBoundaries(bmp);
            }
        }
        private void udPenwidth_ValueChanged(object sender, EventArgs e)
        {
            UpdateBitmap();
            UpdatePanels(true);
            pbFull.Refresh();
        }

        private void rbPie_CheckedChanged(object sender, EventArgs e)
        {
            UpdateBitmap();
            UpdatePanels(true);
            pbFull.Refresh();
        }

        private void rbLine_CheckedChanged(object sender, EventArgs e)
        {
            UpdateBitmap();
            UpdatePanels(true);
            pbFull.Refresh();
        }

        private void cbMultipenColor_CheckedChanged(object sender, EventArgs e)
        {
            UpdateBitmap();
            UpdatePanels(true);
            pbFull.Refresh();
        }

        private void btFolderExplorer_Click(object sender, EventArgs e)
        {
            if (dataProvider == null)
            {
                dataProvider = new UPDataProvider();
                dataProvider.IsDataStop = true;
            }
            if (dataProvider.IsDataStop == true)
            {
                try
                {
                    FolderBrowserDialog fbd = new FolderBrowserDialog();
                    // Show the FolderBrowserDialog.
                    DialogResult result = fbd.ShowDialog();
                    
                    if (result == DialogResult.OK)
                    {
                        bool fn = false;
                        string folderName = fbd.SelectedPath;
                        //get selected path
                        folderPath = fbd.SelectedPath;
                        try
                        {
                            Task[] tasks = new Task[2];
                            tokenSource = new CancellationTokenSource();
                            token = tokenSource.Token;
                            tasks[0] = Task.Factory.StartNew(() =>
                            {
                                dataProvider.IsDataStop = false;
                                isCancel = false;
                                if (stopwatch.IsRunning)
                                {
                                    // Stop the timer; show the start and reset buttons.
                                    stopwatch.Stop();
                                }
                                else
                                {
                                    // Start the timer; show the stop and lap buttons.
                                    stopwatch.Reset();
                                    stopwatch.Start();
                                }
                                this.Invoke(DelegateAddObject, new object[] { 99, "Getting UNIPEN data, please be patient...." });
                                dataProvider.Folder.FillFolderTree(folderName);
                                dataProvider.IsDataStop = true;
                                if (!isCancel)
                                {
                                    this.Invoke(DelegateAddObject, new object[] { 97, "Congatulation! UNIPEN data loaded succesfully!" });

                                }
                                else
                                {
                                    this.Invoke(DelegateAddObject, new object[] { 96, "Sorry! UNIPEN data loaded fail!" });

                                }
                                fn = true;
                                if (token.IsCancellationRequested)
                                {
                                    token.ThrowIfCancellationRequested();
                                }

                            }, token);
                            tasks[1] = Task.Factory.StartNew(() =>
                            {
                                int i = 0;
                                while (!fn)
                                {
                                    Thread.Sleep(100);
                                    this.Invoke(DelegateAddObject, new object[] { 98, i });
                                    i++;
                                    if (i >= 100)
                                        i = 0;
                                }
                                this.Invoke(DelegateAddObject, new object[] { 98, 0 });
                            });
                        }
                        catch (Exception ex)
                        {
                            
                        }
                    }


                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString());
                }

                UpdatePanels(true);
            }
            else
            {
                DialogResult result = MessageBox.Show("Do you really want to cancel this process?", "Cancel loadding Images", MessageBoxButtons.YesNo);
                if (result == DialogResult.Yes)
                {
                    dataProvider.IsDataStop = true;
                    isCancel = true;
                    tokenSource.Cancel();
                }
            }
        }
        private void PatternRecognition()
        {
            if (networks != null)
            {
                if (currentUnipen.Hierachy == "CHARACTER")
                {
                    //it is a character, Test handwriting recognition system
                    Char label = currentUnipen.Label[1]; // Label[0] is '\"'
                    //if (network.TagetOutputs.Contains(label))
                    //{
                    //ok network can recognize the pattern

                    UnipenBitmap ibox = new UnipenBitmap(currentUnipen, (int)udPenwidth.Value);
                    if (rbLine.Checked)
                    {
                        ibox.Drawtype = DrawType.Line;
                    }
                    else if (rbPie.Checked)
                    {
                        ibox.Drawtype = DrawType.Pie;
                    }
                    ibox.Multicolor = cbMultipenColor.Checked;
                    ibox.PenWidth = (int)udPenwidth.Value;
                    ibox.Uppen = cbUppen.Checked;
                    Bitmap bmp = ibox.GetBitmap(2, new Size(29, 29), true);
                    byte[] imagedata = ImageProcessing.ConvertGrayscaleBitmaptoBytes(bmp);
                    Char accLabel=new Char();
                    bool isCharFound = false;
                    foreach (var nw in networks)
                    {
                        Neurons.PatternTesting patterntest = new PatternTesting(nw, this);
                        patterntest.ForwardpropagationThread(imagedata, bmp.Width, bmp.Height, out accLabel);
                        if (accLabel != nw.UnknownOuput)
                        {
                            isCharFound = true;
                            break;
                        }
                    }
                    if (isCharFound)
                    {
                        if (accLabel != label)
                        {

                            lbComment.Text = String.Format("Sad, I thought it was '{0}' but it is '{1}'. I have to learn more!", accLabel, label);
                            pBSmile.Image = global::NNControl.Properties.Resources.cry;

                        }
                        else
                        {
                            lbComment.Text = String.Format("Ha ha, it is too easy to me, it is '{0}'. Find a more difficult character please!", accLabel);
                            pBSmile.Image = global::NNControl.Properties.Resources.smile;

                        }
                    }
                    else
                    {

                        lbComment.Text = String.Format("I do not know this character, sorry");
                        pBSmile.Image = global::NNControl.Properties.Resources.cry;
                    }
                    label3.Text = accLabel.ToString();
                    pictureBox1.Image = ImageProcessing.MarkIndexedPattern(bmp, 2, 255);
                    lbComment.Visible = true;
                    pBSmile.Visible = true;
                 
                }
                else
                {
                    lbComment.Text = "Network can not recognize this image because it is not CHARACTER";
                    pBSmile.Image = global::NNControl.Properties.Resources.cry;
                }
            }
        }
        private void btLoad_Click(object sender, EventArgs e)
        {
            LoadTrainedParametersFiles();
        }
        private void LoadTrainedParametersFiles()
        {
            OpenFileDialog OpenFileDialog1 = new System.Windows.Forms.OpenFileDialog { Filter = "Neural network parameters file (*.nnt)|*.nnt", Title = "Load Neural network File" };
            OpenFileDialog1.Multiselect = true;
            try
            {
                if (OpenFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    // Read the files
                    if (networks != null)
                    {
                        networks.Clear();
                        networks = null;
                    }
                    networks = new List<ConvolutionNetwork>();
                    foreach (String file in OpenFileDialog1.FileNames)
                    {
                        // Create a PictureBox.
                        try
                        {
                            ConvolutionNetwork nw = new ConvolutionNetwork();
                            var fsIn = new StreamReader(file);
                            var arIn = new Archive(fsIn.BaseStream, ArchiveOp.load);
                            nw.Serialize(arIn);
                            fsIn.Close();
                            networks.Add(nw);
                        }
                        catch (Exception ex)
                        {
                            toolStripStatusLabel.Text = "Network loaded fail!";
                            return;
                        }
                    }
                    toolStripStatusLabel.Text = "Network loaded successfully!";
                }
            }
            finally
            {
                if (OpenFileDialog1 != null)
                    OpenFileDialog1.Dispose();
            }
        }
        private void cbRecognition_CheckedChanged(object sender, EventArgs e)
        {
            if (cbRecognition.Checked)
            {
                btRecognition.Enabled = false;
            }
            else
            {
                btRecognition.Enabled = true;
            }
        }

        private void btRecognition_Click(object sender, EventArgs e)
        {
            if (folderPath != "")
            {

                if (dataProvider.IsDataStop == true)
                {
                    try
                    {
                        bool fn = false;
                        Task[] tasks = new Task[2];
                        tokenSource = new CancellationTokenSource();
                        token = tokenSource.Token;
                        tasks[0] = Task.Factory.StartNew(() =>
                        {
                            dataProvider.IsDataStop = false;
                            isCancel = false;
                            if (stopwatch.IsRunning)
                            {
                                // Stop the timer; show the start and reset buttons.
                                stopwatch.Stop();
                            }
                            else
                            {
                                // Start the timer; show the stop and lap buttons.
                                stopwatch.Reset();
                                stopwatch.Start();
                            }
                            this.Invoke(DelegateAddObject, new object[] { 95, "Getting UNIPEN data, please be patient...." });
                            dataProvider.GetPatternsFromFiles(folderPath);
                            dataProvider.IsDataStop = true;
                            // test all data in selected folder
                            if (!isCancel)
                            {
                                ByteImageData[] dt = new ByteImageData[dataProvider.ByteImagePatterns.Count];
                                dataProvider.ByteImagePatterns.CopyTo(dt);
                                int missPatterns = 0;
                                this.Invoke(DelegateAddObject, new object[] { 95, "Starting recognize all characters in selected folder, please wait...." });
                                for (int i = 0; i < dataProvider.ByteImagePatterns.Count;i++ )
                                {
                                    Char accLabel=new Char();
                                    bool isCharFound = false;
                                    foreach (var nw in networks)
                                    {
                                        Neurons.PatternTesting patterntest = new PatternTesting(nw, this);
                                        patterntest.ForwardpropagationThread(dt[i].Image, 29, 29, out accLabel);
                                        if (accLabel != nw.UnknownOuput)
                                        {
                                            isCharFound = true;
                                            break;
                                        }
                                    }
                                    if (isCharFound)
                                    {
                                        if (accLabel != dt[i].Label)
                                        {
                                            missPatterns++;
                                        }
                                    }
                                    else
                                    {
                                        missPatterns++;
                                    }
                                    if (isCancel)
                                    {
                                        break;
                                    }
                                }
                                this.Invoke(DelegateAddObject, new object[] { 94, String.Format("Congatulation! UNIPEN data is recognized succesfully! No of misspattern is: {0} / {1}", missPatterns, dataProvider.ByteImagePatterns.Count) });

                            }
                            else
                            {
                                this.Invoke(DelegateAddObject, new object[] { 94, "Sorry! UNIPEN data loaded fail!" });

                            }
                            fn = true;
                            if (token.IsCancellationRequested)
                            {
                                token.ThrowIfCancellationRequested();
                            }

                        }, token);
                        tasks[1] = Task.Factory.StartNew(() =>
                        {
                            int i = 0;
                            while (!fn)
                            {
                                Thread.Sleep(100);
                                this.Invoke(DelegateAddObject, new object[] { 98, i });
                                i++;
                                if (i >= 100)
                                    i = 0;
                            }
                            this.Invoke(DelegateAddObject, new object[] { 98, 0 });
                        });
                    }
                    catch (Exception ex)
                    {

                    }

                }
                else
                {
                    DialogResult result = MessageBox.Show("Do you really want to cancel this process?", "Cancel loadding Images", MessageBoxButtons.YesNo);
                    if (result == DialogResult.Yes)
                    {
                        dataProvider.IsDataStop = true;
                        isCancel = true;
                        tokenSource.Cancel();
                    }
                }
            }
        }

        private void timerMain_Tick(object sender, EventArgs e)
        {
            if (stopwatch.IsRunning)
            {
                // Get the elapsed time as a TimeSpan value.
                TimeSpan ts = stopwatch.Elapsed;

                // Format and display the TimeSpan value.
                toolStripStatusLabel1.Text = String.Format("{0:00}:{1:00}:{2:00}.{3:00}",
                    ts.Hours, ts.Minutes, ts.Seconds,
                    ts.Milliseconds / 10);

                // If the user has just clicked the "Lap" button,
                // then capture the current time for the lap time.
            }
        }

    }
    public class ImageViewerRotationEventArgs : EventArgs
    {
        private int rotation;
        public int Rotation
        {
            get { return rotation; }
        }

        public ImageViewerRotationEventArgs(int rotation)
        {
            this.rotation = rotation;
        }
    }
    public class ImageViewerZoomEventArgs : EventArgs
    {
        private int zoom;
        public int Zoom
        {
            get { return zoom; }
        }

        private KpZoom inOut;
        public KpZoom InOut
        {
            get { return inOut; }
        }

        public ImageViewerZoomEventArgs(double zoom, KpZoom inOut)
        {
            this.zoom = Convert.ToInt32(Math.Round((zoom * 100), 0));
            this.inOut = inOut;
        }
    }
}
